<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;

final class TimePickerNode extends FieldNode
{
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly string $format = '24h',
        public readonly string|null $minTime = null,
        public readonly string|null $maxTime = null,
        public readonly int $interval = 15,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly bool $withSeconds = false,
        public readonly bool $withDropdown = false,
        public readonly int $hoursStep = 1,
        public readonly int $minutesStep = 1,
        public readonly int $secondsStep = 1,
        public readonly int $maxDropdownContentHeight = 200,
        public readonly bool $reverseTimeControlsList = false,
    ) {
        parent::__construct('TimePicker');
    }
}
