<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Schema;

final class RowElementSchema extends ElementSchema
{
    /** @param list<ElementSchema> $elements */
    public function __construct(
        public array $elements = [],
        int $span = 12,
        public string|null $title = null,
        public int $size = 5,
    ) {
        parent::__construct($span);
    }

    public function getType(): string
    {
        return 'row';
    }
}
