<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

use MSML\Blueprint\DSL\Enums\HorizontalPosition;

trait WithSelectProps
{
    public function searchable(bool $searchable = true): self
    {
        $this->updateNodeWith(['searchable' => $searchable]);

        return $this;
    }

    public function clearable(bool $clearable = true): self
    {
        $this->updateNodeWith(['clearable' => $clearable]);

        return $this;
    }

    public function limit(int $limit): self
    {
        $this->updateNodeWith(['limit' => $limit]);

        return $this;
    }

    public function nothingFoundMessage(string $message): self
    {
        $this->updateNodeWith(['nothingFoundMessage' => $message]);

        return $this;
    }

    public function withCheckIcon(bool $withCheckIcon = true): self
    {
        $this->updateNodeWith(['withCheckIcon' => $withCheckIcon]);

        return $this;
    }

    public function checkIconPosition(HorizontalPosition $position): self
    {
        $this->updateNodeWith(['checkIconPosition' => $position]);

        return $this;
    }

    public function checkIconLeft(): self
    {
        $this->updateNodeWith(['checkIconPosition' => HorizontalPosition::Left]);

        return $this;
    }

    public function checkIconRight(): self
    {
        $this->updateNodeWith(['checkIconPosition' => HorizontalPosition::Right]);

        return $this;
    }

    public function allowDeselect(bool $allow = true): self
    {
        $this->updateNodeWith(['allowDeselect' => $allow]);

        return $this;
    }

    public function selectFirstOptionOnChange(bool $select = true): self
    {
        $this->updateNodeWith(['selectFirstOptionOnChange' => $select]);

        return $this;
    }
}
