<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithSliderBounds
{
    public function min(float|int $min): self
    {
        $this->updateNodeWith(['min' => $min]);

        return $this;
    }

    public function max(float|int $max): self
    {
        $this->updateNodeWith(['max' => $max]);

        return $this;
    }

    public function step(float|int $step): self
    {
        $this->updateNodeWith(['step' => $step]);

        return $this;
    }

    /**
     * @param  array<int|float>  $marks
     */
    public function marks(array $marks): self
    {
        $this->updateNodeWith(['marks' => $marks]);

        return $this;
    }

    public function minDomain(float|int $minDomain): self
    {
        $this->updateNodeWith(['minDomain' => $minDomain]);

        return $this;
    }

    public function maxDomain(float|int $maxDomain): self
    {
        $this->updateNodeWith(['maxDomain' => $maxDomain]);

        return $this;
    }

    public function domain(float|int $min, float|int $max): self
    {
        $this->updateNodeWith(['minDomain' => $min, 'maxDomain' => $max]);

        return $this;
    }
}
