<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

final readonly class AccordionNode
{
    /**
     * @param  array<AccordionItemNode>  $items
     * @param  array<string>|null  $defaultOpen
     */
    public function __construct(
        public int $span = 12,
        public array $items = [],
        public bool $multiple = false,
        public array|null $defaultOpen = null,
        public string $chevronPosition = 'right',
        public string|null $variant = null,
        public string|null $radius = null,
    ) {}
}
