<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;

final class DateInputNode extends FieldNode
{
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly string|null $format = 'DD-MM-YYYY',
        public readonly string|null $placeholder = null,
        public readonly string|null $help = null,
        public readonly string|null $minDate = null,
        public readonly string|null $maxDate = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly bool $clearable = false,
    ) {
        parent::__construct('DateInput');
    }
}
