<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

final class FileInputNode extends FieldNode
{
    /**
     * @param  list<string>|null  $accept
     * @param  array{id:int,url:string,name:string}|null  $selected
     */
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly array|null $accept = null,
        public readonly int|null $maxSize = null,
        public readonly string|null $help = null,
        public readonly string|null $uploadEndpoint = null,
        public readonly string|null $namespace = null,
        public readonly string|null $collection = null,
        public readonly bool $allowBrowse = false,
        public readonly array|null $selected = null,
    ) {
        parent::__construct('FileInput');
    }
}
