<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

final class RichTextEditorNode extends FieldNode
{
    /**
     * @param  list<string>|null  $toolbar
     */
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly array|null $toolbar = null,
        public readonly string|null $placeholder = null,
        public readonly int|null $maxLength = null,
        public readonly string|null $help = null,
    ) {
        parent::__construct('RichTextEditor');
    }
}
