<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Enums\TextInputType;

final class TextInputNode extends FieldNode
{
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly string|null $placeholder = null,
        public readonly TextInputType $inputType = TextInputType::Text,
        public readonly int|null $maxLength = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly string|null $iconLeft = null,
        public readonly string|null $iconRight = null,
    ) {
        parent::__construct('TextInput');
    }
}
