<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Schema;

use Spatie\LaravelData\Data;

final class RelationEndpointSchema extends Data
{
    /**
     * @param  array<string,string>  $headers
     * @param  array<string,mixed>  $static
     */
    public function __construct(
        public string $url,
        public string $method = 'GET',
        public string $qParam = 'q',
        public string $itemsPath = 'data',
        public string $labelPath = 'label',
        public string $valuePath = 'value',
        public string|null $pageParam = 'page',
        public string|null $perPageParam = 'per_page',
        public array $headers = [],
        public array $static = [],
    ) {}
}
