<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

use MSML\Blueprint\DSL\Enums\ClampBehavior;

trait WithNumberFormat
{
    public function allowNegative(bool $allow = true): self
    {
        $this->updateNodeWith(['allowNegative' => $allow]);

        return $this;
    }

    public function allowDecimal(bool $allow = true): self
    {
        $this->updateNodeWith(['allowDecimal' => $allow]);

        return $this;
    }

    public function prefix(string $prefix): self
    {
        $this->updateNodeWith(['prefix' => $prefix]);

        return $this;
    }

    public function suffix(string $suffix): self
    {
        $this->updateNodeWith(['suffix' => $suffix]);

        return $this;
    }

    public function clampBehavior(ClampBehavior $behavior): self
    {
        $this->updateNodeWith(['clampBehavior' => $behavior]);

        return $this;
    }

    public function clampStrict(): self
    {
        $this->updateNodeWith(['clampBehavior' => ClampBehavior::Strict]);

        return $this;
    }

    public function clampBlur(): self
    {
        $this->updateNodeWith(['clampBehavior' => ClampBehavior::Blur]);

        return $this;
    }

    public function clampNone(): self
    {
        $this->updateNodeWith(['clampBehavior' => ClampBehavior::None]);

        return $this;
    }

    public function hideControls(bool $hide = true): self
    {
        $this->updateNodeWith(['hideControls' => $hide]);

        return $this;
    }

    public function thousandSeparator(bool|string $separator = true): self
    {
        $normalized = $separator === true ? ',' : ($separator === false ? null : $separator);
        $this->updateNodeWith(['thousandSeparator' => $normalized]);

        return $this;
    }

    public function fixedDecimalScale(bool $fixed = true): self
    {
        $this->updateNodeWith(['fixedDecimalScale' => $fixed]);

        return $this;
    }

    public function decimalScale(int $scale): self
    {
        $this->updateNodeWith(['decimalScale' => $scale]);

        return $this;
    }
}
