<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithSegmentedControlProps
{
    public function readOnly(bool $readOnly = true): self
    {
        $this->updateNodeWith(['readOnly' => $readOnly]);

        return $this;
    }

    public function autoContrast(bool $autoContrast = true): self
    {
        $this->updateNodeWith(['autoContrast' => $autoContrast]);

        return $this;
    }

    public function fullWidth(bool $fullWidth = true): self
    {
        $this->updateNodeWith(['fullWidth' => $fullWidth]);

        return $this;
    }

    public function radius(string $radius): self
    {
        $this->updateNodeWith(['radius' => $radius]);

        return $this;
    }

    public function orientation(string $orientation): self
    {
        $this->updateNodeWith(['orientation' => $orientation]);

        return $this;
    }

    public function withItemsBorders(bool $withItemsBorders = true): self
    {
        $this->updateNodeWith(['withItemsBorders' => $withItemsBorders]);

        return $this;
    }

    /**
     * @param  string|array{label:string,value:mixed}  $option
     */
    public function addOption(array|string $option): self
    {
        $current = $this->node->data;
        $current[] = $option;
        $this->updateNodeWith(['data' => $current]);

        return $this;
    }

    /**
     * @param  list<string|array{label:string,value:mixed}>  $options
     */
    public function options(array $options): self
    {
        $this->updateNodeWith(['data' => $options]);

        return $this;
    }
}
