<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

use MSML\Blueprint\DSL\Enums\ResizeMode;

trait WithTextareaAutosize
{
    public function autosize(bool $autosize = true): self
    {
        $this->updateNodeWith(['autosize' => $autosize]);

        return $this;
    }

    public function minRows(int $rows): self
    {
        $this->updateNodeWith(['minRows' => $rows]);

        return $this;
    }

    public function maxRows(int $rows): self
    {
        $this->updateNodeWith(['maxRows' => $rows]);

        return $this;
    }

    public function resize(ResizeMode $mode): self
    {
        $this->updateNodeWith(['resize' => $mode]);

        return $this;
    }

    public function resizeNone(): self
    {
        $this->updateNodeWith(['resize' => ResizeMode::None]);

        return $this;
    }

    public function resizeVertical(): self
    {
        $this->updateNodeWith(['resize' => ResizeMode::Vertical]);

        return $this;
    }

    public function resizeBoth(): self
    {
        $this->updateNodeWith(['resize' => ResizeMode::Both]);

        return $this;
    }
}
