# Laravel Blueprint Documentation

Laravel Blueprint is a focused package that provides a fluent DSL (Domain Specific Language) for building UI form specifications. The package is designed to be **consumer-agnostic** - it only handles blueprint building and specification generation, leaving implementation details to the consumer.

## Quick Navigation

### 🚀 Getting Started
- [Installation](docs/getting-started/installation.md) - Setup and basic configuration
- [Quick Start](docs/getting-started/quick-start.md) - Your first blueprint in 5 minutes
- [Core Concepts](docs/getting-started/core-concepts.md) - Understanding the architecture
- [DTO Integration](docs/getting-started/dto-integration.md) - Working with Data Transfer Objects

### 📚 API Reference
- **Builders**
  - [BlueprintCompiler](docs/api-reference/builders/blueprint-compiler.md) - Main DSL entry point
  - [TabBuilder](docs/api-reference/builders/tab-builder.md) - Tab layout and organization
  - [RowBuilder](docs/api-reference/builders/row-builder.md) - Row containers and nesting
  - [Field Builders](docs/api-reference/builders/field-builders.md) - All 20+ field builders
- **Core Systems**
  - [Validation](docs/api-reference/validation.md) - Rules, scoping, and validation patterns
  - [Layout System](docs/api-reference/layout-system.md) - Spans, rows, nesting, tabs
  - [Schema Output](docs/api-reference/schema-output.md) - BlueprintSchema structure


## Package Architecture

Laravel Blueprint follows a **Tab-Based Recursive DSL** architecture:

```
Blueprint → Tab → Row → Element(Component|Row) [recursive]
```

### Key Features

- **🏗️ Tab-Based DSL** - Organize forms with tabs containing rows and components
- **🔄 Recursive Nesting** - Unlimited row nesting for complex layouts
- **📐 Universal Span System** - All elements support 1-12 column positioning
- **✅ Validation Integration** - Built-in validation rule building
- **🎯 Scoped Validation** - Dynamic validation based on field dependencies
- **📦 DTO Integration** - Seamless integration with Spatie Laravel Data
- **🔧 Consumer Agnostic** - No opinions on implementation details

### What This Package Provides

- **Blueprint Building** - Fluent DSL for constructing form specifications
- **Schema Generation** - Immutable data objects describing form structure
- **Validation Rules** - Automatic Laravel validation rule generation
- **Layout Specifications** - Tab, row, and component positioning data

### What Consumers Implement

- **DTOs** - Data Transfer Objects implementing `DefinesBlueprint`
- **Models & Traits** - Blueprint field casting and model integration
- **Controllers** - Create/update workflows using generated specs
- **Database** - Schema for blueprint storage and retrieval
- **Frontend** - UI rendering based on blueprint specifications

