<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Nodes\ComboboxNode;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithOptions;
use MSML\Blueprint\DSL\Traits\Common\WithMultiple;
use MSML\Blueprint\DSL\Traits\Common\WithPlaceholder;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\Specialized\WithSearchable;

final class ComboboxBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use NodeUpdater;
    use SpanUpdater;
    use WithHelp;
    use WithMultiple;
    use WithOptions;
    use WithPlaceholder;
    use WithRules;
    use WithSearchable;

    protected ComboboxNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;

        $this->node = new ComboboxNode(
            label: $label,
            options: [],
            span: 12,
            placeholder: null,
            searchable: true,
            creatable: false,
            multiple: false,
            help: null
        );

        $this->registerInLayout();
        $this->updateNode();
    }

    /** @param string|array<string> $value**/
    public function value(array|string $value): self
    {
        $this->root->defaults[$this->key] = $value;

        return $this;
    }
}
