<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Nodes\DateRangePickerNode;
use MSML\Blueprint\DSL\Traits\Common\WithVariant;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Common\WithPlaceholder;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasDateTimeValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithMultipleRules;
use MSML\Blueprint\DSL\Traits\Specialized\WithDateTimeBounds;
use MSML\Blueprint\DSL\Traits\Specialized\WithDatePickerProps;

final class DateRangePickerBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasDateTimeValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithDatePickerProps;
    use WithDateTimeBounds;
    use WithDisabled;
    use WithHelp;
    use WithMultipleRules;
    use WithPlaceholder;
    use WithSize;
    use WithVariant;

    protected DateRangePickerNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $from,
        string $to,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $from;
        $this->context = $context;
        $this->node = new DateRangePickerNode(
            from: $from,
            to: $to,
            label: $label,
            span: 12,
            format: 'DD-MM-YY',
            placeholder: null,
            help: null,
            minDate: null,
            maxDate: null,
            size: Size::SM,
            variant: Variant::Default,
            disabled: false,
            clearable: false,
            firstDayOfWeek: 1,
            hideOutsideDates: false,
            highlightToday: false,
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
