<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Nodes\SelectNode;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Enums\HorizontalPosition;
use MSML\Blueprint\DSL\Traits\Common\WithOptions;
use MSML\Blueprint\DSL\Traits\Common\WithVariant;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Common\WithMultiple;
use MSML\Blueprint\DSL\Traits\Common\WithPlaceholder;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\Specialized\WithSelectProps;

final class SelectBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use NodeUpdater;
    use SpanUpdater;
    use WithDisabled;
    use WithHelp;
    use WithMultiple;
    use WithOptions;
    use WithPlaceholder;
    use WithRules;
    use WithSelectProps;
    use WithSize;
    use WithVariant;

    protected SelectNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;
        $this->node = new SelectNode(
            label: $label,
            options: [],
            span: 12,
            placeholder: null,
            multiple: false,
            help: null,
            size: Size::SM,
            variant: Variant::Default,
            disabled: false,
            searchable: false,
            clearable: false,
            limit: null,
            nothingFoundMessage: null,
            withCheckIcon: true,
            checkIconPosition: HorizontalPosition::Left,
            allowDeselect: true,
            selectFirstOptionOnChange: false
        );

        $this->registerInLayout();
        $this->updateNode();
    }

    /**
     * @param  string|array<string|int, mixed>  $value
     */
    public function value(array|string $value): self
    {
        $this->root->defaults[$this->key] = $value;

        return $this;
    }
}
