<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Nodes\TimeGridNode;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasStringValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithTimeBounds;
use MSML\Blueprint\DSL\Traits\Specialized\WithTimeGridProps;

final class TimeGridBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasStringValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithDisabled;
    use WithHelp;
    use WithRules;
    use WithSize;
    use WithTimeBounds;
    use WithTimeGridProps;

    protected TimeGridNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;

        $this->node = new TimeGridNode(
            label: $label,
            span: 12,
            format: '24h',
            data: [],
            minTime: null,
            maxTime: null,
            help: null,
            size: Size::SM,
            disabled: false,
            withSeconds: false,
            allowDeselect: false,
            disableTime: null,
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
