<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

final class ComboboxNode extends FieldNode
{
    /**
     * @param  list<string|array{label:string,value:mixed}>  $options
     */
    public function __construct(
        public readonly string|null $label,
        public readonly array $options,
        public readonly int $span = 12,
        public readonly string|null $placeholder = null,
        public readonly bool $searchable = true,
        public readonly bool $creatable = false,
        public readonly bool $multiple = false,
        public readonly string|null $help = null,
    ) {
        parent::__construct('Combobox');
    }
}
