<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;

final class SegmentedControlNode extends FieldNode
{
    /**
     * @param  list<string|array{label:string,value:mixed}>  $data
     */
    public function __construct(
        public readonly string|null $label,
        public readonly array $data = [],
        public readonly int $span = 12,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly string|null $color = null,
        public readonly string|null $radius = null,
        public readonly bool $disabled = false,
        public readonly bool $readOnly = false,
        public readonly bool $fullWidth = false,
        public readonly bool $inline = false,
        public readonly bool $withItemsBorders = true
    ) {
        parent::__construct('SegmentedControl');
    }
}
