<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;

final class TimeGridNode extends FieldNode
{
    /**
     * @param  array<string>|null  $disableTime
     * @param  array<string>  $data
     */
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly array $data = [],
        public readonly string $format = '24h',
        public readonly string|null $minTime = null,
        public readonly string|null $maxTime = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly bool $disabled = false,
        public readonly bool $withSeconds = false,
        public readonly bool $allowDeselect = false,
        public readonly array|null $disableTime = null,
    ) {
        parent::__construct('TimeGrid');
    }
}
