<?php

namespace MSML\Blueprint\DSL\Traits\Core;

use MSML\Blueprint\DSL\Builders\RowBuilder;
use MSML\Blueprint\DSL\Builders\TabBuilder;
use MSML\Blueprint\DSL\Builders\PanelBuilder;
use MSML\Blueprint\DSL\Builders\FieldsetBuilder;

trait NodeUpdater
{
    protected function updateNode(): void
    {
        $this->root->components[$this->key] = $this->node;
    }

    /** @param  array<string, mixed>  $updates */
    protected function updateNodeWith(array $updates): void
    {
        $this->node = $this->node->withUpdates($updates);
        $this->updateNode();
    }

    protected function registerInLayout(): void
    {
        if ($this->context instanceof RowBuilder) {
            $this->context->registerComponent($this->key, 12);
        } elseif ($this->context instanceof TabBuilder) {
            $currentRow = $this->context->getCurrentRow();
            $currentRow->registerComponent($this->key, 12);
        } elseif ($this->context instanceof PanelBuilder) {
            $this->context->registerComponent($this->key, 12);
        } elseif ($this->context instanceof FieldsetBuilder) {
            $this->context->registerComponent($this->key, 12);
        }

        $this->root->rules[$this->key] = ['nullable'];
    }
}
