<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithRangeSliderProps
{
    use WithSliderProps;

    public function minRange(float|int $minRange): self
    {
        $this->updateNodeWith(['minRange' => $minRange]);

        return $this;
    }

    public function maxRange(float|int $maxRange): self
    {
        $this->updateNodeWith(['maxRange' => $maxRange]);

        return $this;
    }

    public function range(float|int $min, float|int $max): self
    {
        $this->updateNodeWith(['minRange' => $min, 'maxRange' => $max]);

        return $this;
    }

    public function pushOnOverlap(bool $pushOnOverlap = true): self
    {
        $this->updateNodeWith(['pushOnOverlap' => $pushOnOverlap]);

        return $this;
    }
}
