<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithSliderProps
{
    public function inverted(bool $inverted = true): self
    {
        $this->updateNodeWith(['inverted' => $inverted]);

        return $this;
    }

    public function restrictToMarks(bool $restrictToMarks = true): self
    {
        $this->updateNodeWith(['restrictToMarks' => $restrictToMarks]);

        return $this;
    }

    public function labelAlwaysOn(bool $labelAlwaysOn = true): self
    {
        $this->updateNodeWith(['labelAlwaysOn' => $labelAlwaysOn]);

        return $this;
    }

    public function showLabelOnHover(bool $showLabelOnHover = true): self
    {
        $this->updateNodeWith(['showLabelOnHover' => $showLabelOnHover]);

        return $this;
    }

    public function thumbSize(int $thumbSize): self
    {
        $this->updateNodeWith(['thumbSize' => $thumbSize]);

        return $this;
    }

    public function precision(int $precision): self
    {
        $this->updateNodeWith(['precision' => $precision]);

        return $this;
    }

    public function radius(string $radius): self
    {
        $this->updateNodeWith(['radius' => $radius]);

        return $this;
    }
}
