<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Nodes\DateTimePickerNode;
use MSML\Blueprint\DSL\Traits\Common\WithVariant;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Common\WithPlaceholder;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasDateTimeValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithDateTimeBounds;
use MSML\Blueprint\DSL\Traits\Specialized\WithDatePickerProps;
use MSML\Blueprint\DSL\Traits\Specialized\WithDateTimePickerProps;

final class DateTimePickerBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasDateTimeValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithDatePickerProps;
    use WithDateTimeBounds;
    use WithDateTimePickerProps;
    use WithDisabled;
    use WithHelp;
    use WithPlaceholder;
    use WithRules;
    use WithSize;
    use WithVariant;

    protected DateTimePickerNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;

        $this->node = new DateTimePickerNode(
            label: $label,
            span: 12,
            format: 'YYYY-MM-DD HH:mm',
            minDate: null,
            maxDate: null,
            placeholder: null,
            help: null,
            size: Size::SM,
            variant: Variant::Default,
            disabled: false,
            clearable: false,
            firstDayOfWeek: 1,
            hideOutsideDates: false,
            highlightToday: false,
            withSeconds: false,
            readOnly: false,
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
