<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Nodes\RichTextEditorNode;
use MSML\Blueprint\DSL\Traits\Common\WithPlaceholder;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasStringValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithTextEditor;

final class RichTextEditorBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasStringValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithHelp;
    use WithPlaceholder;
    use WithRules;
    use WithTextEditor;

    protected RichTextEditorNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;

        $this->node = new RichTextEditorNode(
            label: $label,
            span: 12,
            toolbar: [],
            placeholder: null,
            maxLength: null,
            help: null
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
