<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Nodes\SliderNode;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithColor;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasNumericValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithSliderProps;
use MSML\Blueprint\DSL\Traits\Specialized\WithSliderBounds;

final class SliderBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasNumericValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithColor;
    use WithDisabled;
    use WithHelp;
    use WithRules;
    use WithSize;
    use WithSliderBounds;
    use WithSliderProps;

    protected SliderNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;

        $this->node = new SliderNode(
            label: $label,
            span: 12,
            min: 0,
            max: 100,
            step: 1,
            marks: null,
            minDomain: null,
            maxDomain: null,
            help: null,
            disabled: false,
            inverted: false,
            restrictToMarks: false,
            labelAlwaysOn: false,
            showLabelOnHover: true,
            size: Size::MD,
            thumbSize: null,
            color: null,
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
