<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Nodes\SwitchNode;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithText;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasBooleanValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithSwitchProps;

final class SwitchBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasBooleanValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithHelp;
    use WithRules;
    use WithSwitchProps;
    use WithText;

    protected SwitchNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;
        $this->node = new SwitchNode(
            label: $label,
            span: 12,
            text: null,
            help: null,
            justifyApart: false,
            labelPosition: 'left'
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
