<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\Enums\ResizeMode;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Nodes\TextareaNode;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithVariant;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Common\WithIconLeft;
use MSML\Blueprint\DSL\Traits\Common\WithIconRight;
use MSML\Blueprint\DSL\Traits\Common\WithPlaceholder;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasStringValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithTextFormat;
use MSML\Blueprint\DSL\Traits\Specialized\WithTextareaAutosize;

final class TextareaBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasStringValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithDisabled;
    use WithHelp;
    use WithIconLeft;
    use WithIconRight;
    use WithPlaceholder;
    use WithRules;
    use WithSize;
    use WithTextareaAutosize;
    use WithTextFormat;
    use WithVariant;

    protected TextareaNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;
        $this->node = new TextareaNode(
            label: $label,
            span: 12,
            placeholder: null,
            rows: null,
            maxLength: null,
            help: null,
            size: Size::SM,
            variant: Variant::Default,
            disabled: false,
            autosize: false,
            minRows: 3,
            maxRows: 10,
            resize: ResizeMode::Vertical
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
