<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;

final class AutoCompleteNode extends FieldNode
{
    /**
     * @param  array<string,mixed>  $endpoint  Empty array or complete endpoint config
     * @param array{
     *   dependsOn: string,
     *   param: string,
     *   clearOnChange?: bool
     * }|null $scope
     * @param  array{value:mixed,label:string}|null  $selected
     */
    public function __construct(
        public readonly string|null $label,
        public readonly array|null $endpoint = null,
        public readonly array|null $selected = null,
        public readonly int $span = 12,
        public readonly array|null $scope = null,
        public readonly bool $multiple = false,
        public readonly int $debounceMs = 250,
        public readonly string|null $placeholder = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly string|null $iconLeft = null,
    ) {
        parent::__construct('Autocomplete');
    }
}
