<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;

final class TagsNode extends FieldNode
{
    /**
     * @param  array<string,mixed>|null  $endpoint
     * @param  list<array{value:mixed,label:string}>|null  $selected
     * @param  list<string|array{label:string,value:mixed}>|null  $suggestions
     */
    public function __construct(
        public readonly string|null $label,
        public readonly array|null $endpoint = null,
        public readonly array|null $selected = null,
        public readonly int $span = 12,
        public readonly int|null $maxTags = null,
        public readonly array|null $suggestions = null,
        public readonly int $debounceMs = 250,
        public readonly string|null $placeholder = null,
        public readonly string|null $help = null,
        public readonly Size $size = Size::SM,
        public readonly Variant $variant = Variant::Default,
        public readonly bool $disabled = false,
        public readonly bool $clearable = true,
        public readonly bool $searchable = true,
        public readonly bool $showSelectedCount = false,
        public readonly string|null $selectedCountSingular = null,
        public readonly string|null $selectedCountPlural = null,
        public readonly string|null $iconLeft = null,
    ) {
        parent::__construct('Tags');
    }
}
