<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Schema;

use MSML\Blueprint\DSL\Enums\Variant;

final class FieldsetElementSchema extends ElementSchema
{
    /** @param list<ElementSchema> $elements */
    public function __construct(
        public array $elements = [],
        int $span = 12,
        public string|null $legend = null,
        public Variant $variant = Variant::Default,
    ) {
        parent::__construct($span);
    }

    public function getType(): string
    {
        return 'fieldset';
    }
}
