<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Common;

use MSML\Blueprint\DSL\Enums\Size;

trait WithSize
{
    public function size(Size $size): self
    {
        $this->updateNodeWith(['size' => $size]);

        return $this;
    }

    public function sizeXs(): self
    {
        $this->updateNodeWith(['size' => Size::XS]);

        return $this;
    }

    public function sizeSm(): self
    {
        $this->updateNodeWith(['size' => Size::SM]);

        return $this;
    }

    public function sizeMd(): self
    {
        $this->updateNodeWith(['size' => Size::MD]);

        return $this;
    }

    public function sizeLg(): self
    {
        $this->updateNodeWith(['size' => Size::LG]);

        return $this;
    }

    public function sizeXl(): self
    {
        $this->updateNodeWith(['size' => Size::XL]);

        return $this;
    }
}
