<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Common;

trait WithTitleSize
{
    private int $titleSize = 5;

    public function titleSize(int $size): self
    {
        $this->titleSize = max(1, min(6, $size));

        return $this;
    }

    public function titleH1(): self
    {
        $this->titleSize = 1;

        return $this;
    }

    public function titleH2(): self
    {
        $this->titleSize = 2;

        return $this;
    }

    public function titleH3(): self
    {
        $this->titleSize = 3;

        return $this;
    }

    public function titleH4(): self
    {
        $this->titleSize = 4;

        return $this;
    }

    public function titleH5(): self
    {
        $this->titleSize = 5;

        return $this;
    }

    public function titleH6(): self
    {
        $this->titleSize = 6;

        return $this;
    }

    protected function getTitleSize(): int
    {
        return $this->titleSize;
    }
}
