<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Core;

use MSML\Blueprint\DSL\Builders\RowBuilder;
use MSML\Blueprint\DSL\Builders\TabBuilder;

trait SpanUpdater
{
    public function span(int $columns): self
    {
        $columns = max(1, min(12, $columns));

        $this->updateNodeWith(['span' => $columns]);

        if ($this->context instanceof RowBuilder) {
            $this->context->updateComponentSpan($this->key, $columns);
        } elseif ($this->context instanceof TabBuilder) {
            $this->context->getCurrentRow()->updateComponentSpan($this->key, $columns);
        }

        return $this;
    }
}
