<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithNumericBounds
{
    public function min(float|int $min): self
    {
        $this->updateNodeWith(['min' => (float)$min]);

        return $this;
    }

    public function max(float|int $max): self
    {
        $this->updateNodeWith(['max' => (float)$max]);

        return $this;
    }

    public function precision(int $precision): self
    {
        $this->updateNodeWith(['precision' => $precision]);

        return $this;
    }

    public function step(float $step): self
    {
        $this->updateNodeWith(['step' => $step]);

        return $this;
    }
}
