<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Nodes\DropzoneNode;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithRules;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithMultiple;
use MSML\Blueprint\DSL\Traits\Specialized\WithFile;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;

final class DropzoneBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use NodeUpdater;
    use SpanUpdater;
    use WithFile;
    use WithHelp;
    use WithMultiple;
    use WithRules;

    protected DropzoneNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $key,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $key;
        $this->context = $context;

        $this->node = new DropzoneNode(
            label: $label,
            span: 12,
            accept: null,
            maxSize: null,
            maxFiles: 1,
            multiple: false,
            help: null
        );

        $this->registerInLayout();
        $this->updateNode();
    }

    public function maxFiles(int $count): self
    {
        $this->updateNodeWith(['maxFiles' => $count]);

        return $this;
    }

    /** @param array<mixed> $value**/
    public function value(array $value): self
    {
        $this->root->defaults[$this->key] = $value;

        return $this;
    }
}
