<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\Enums\Variant;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Nodes\FrequencyNode;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithVariant;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\Specialized\WithNumericBounds;
use MSML\Blueprint\DSL\Traits\Specialized\WithFrequencyRules;

final class FrequencyBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use NodeUpdater;
    use SpanUpdater;
    use WithDisabled;
    use WithFrequencyRules;
    use WithHelp;
    use WithNumericBounds;
    use WithSize;
    use WithVariant;

    protected FrequencyNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $valueKey,
        string $unitKey,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $valueKey;
        $this->context = $context;
        $this->node = new FrequencyNode(
            valueKey: $valueKey,
            unitKey: $unitKey,
            label: $label,
            units: [],
            plainText: null,
            span: 12,
            min: null,
            max: null,
            step: null,
            help: null,
            size: Size::SM,
            variant: Variant::Default,
            disabled: false,
        );

        $this->registerInLayout();
        $this->updateNode();
    }

    /**
     * @param  array<string>  $units
     */
    public function units(array $units): self
    {
        $this->updateNodeWith(['units' => $units]);

        return $this;
    }

    public function plainText(string $text): self
    {
        $this->updateNodeWith(['plainText' => $text]);

        return $this;
    }

    public function value(float|int $value): self
    {
        $this->root->defaults[$this->node->valueKey] = $value;

        return $this;
    }

    public function unit(string $unit): self
    {
        $this->root->defaults[$this->node->unitKey] = $unit;

        return $this;
    }
}
