<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Builders;

use MSML\Blueprint\DSL\Enums\Size;
use MSML\Blueprint\DSL\BlueprintCompiler;
use MSML\Blueprint\DSL\Nodes\RangeSliderNode;
use MSML\Blueprint\DSL\Contracts\FieldBuilder;
use MSML\Blueprint\DSL\Traits\Common\WithHelp;
use MSML\Blueprint\DSL\Traits\Common\WithSize;
use MSML\Blueprint\DSL\Traits\Common\WithColor;
use MSML\Blueprint\DSL\Traits\Core\NodeUpdater;
use MSML\Blueprint\DSL\Traits\Core\SpanUpdater;
use MSML\Blueprint\DSL\Traits\Common\WithDisabled;
use MSML\Blueprint\DSL\Traits\Core\CoreBuilderMethods;
use MSML\Blueprint\DSL\Traits\ValueTypes\HasTupleValue;
use MSML\Blueprint\DSL\Traits\Specialized\WithSliderBounds;
use MSML\Blueprint\DSL\Traits\Specialized\WithMultipleRules;
use MSML\Blueprint\DSL\Traits\Specialized\WithRangeSliderProps;

final class RangeSliderBuilder implements FieldBuilder
{
    use CoreBuilderMethods;
    use HasTupleValue;
    use NodeUpdater;
    use SpanUpdater;
    use WithColor;
    use WithDisabled;
    use WithHelp;
    use WithMultipleRules;
    use WithRangeSliderProps;
    use WithSize;
    use WithSliderBounds;

    protected RangeSliderNode $node;

    public function __construct(
        BlueprintCompiler $root,
        int $sectionIndex,
        int $rowIndex,
        string $from,
        string $to,
        string|null $label,
        FieldsetBuilder|PanelBuilder|RowBuilder|TabBuilder $context
    ) {
        $this->root = $root;
        $this->sectionIndex = $sectionIndex;
        $this->rowIndex = $rowIndex;
        $this->key = $from;
        $this->context = $context;

        $this->node = new RangeSliderNode(
            from: $from,
            to: $to,
            label: $label,
            span: 12,
            min: 0,
            max: 100,
            step: 1,
            marks: null,
            minRange: null,
            maxRange: null,
            minDomain: null,
            maxDomain: null,
            help: null,
            disabled: false,
            inverted: false,
            restrictToMarks: false,
            labelAlwaysOn: false,
            showLabelOnHover: true,
            size: Size::MD,
            thumbSize: null,
            color: null,
            pushOnOverlap: true,
        );

        $this->registerInLayout();
        $this->updateNode();
    }
}
