<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;

final readonly class DividerNode
{
    public function __construct(
        public int $span = 12,
        public string|null $color = null,
        public string|null $label = null,
        public string $labelPosition = 'center',
        public string $orientation = 'horizontal',
        public Size $size = Size::XS,
    ) {}
}
