<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

final class DropzoneNode extends FieldNode
{
    /**
     * @param  list<string>|null  $accept
     */
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly array|null $accept = null,
        public readonly int|null $maxSize = null,
        public readonly int $maxFiles = 1,
        public readonly bool $multiple = false,
        public readonly string|null $help = null,
    ) {
        parent::__construct('Dropzone');
    }
}
