<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Attributes\Computed;

abstract class FieldNode extends Data
{
    #[Computed]
    public string $type;

    public function __construct(
        public readonly string $component
    ) {
        $this->type = 'component';
    }

    /** @param  array<string, mixed>  $updates */
    public function withUpdates(array $updates): static
    {
        $data = $this->toArray();
        unset($data['type']);

        return static::from(array_merge($data, $updates));
    }
}
