<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Nodes;

use MSML\Blueprint\DSL\Enums\Size;

final class SliderNode extends FieldNode
{
    /**
     * @param  array<int|float>|null  $marks
     */
    public function __construct(
        public readonly string|null $label,
        public readonly int $span = 12,
        public readonly float|int $min = 0,
        public readonly float|int $max = 100,
        public readonly float|int $step = 1,
        public readonly array|null $marks = null,
        public readonly float|int|null $minDomain = null,
        public readonly float|int|null $maxDomain = null,
        public readonly string|null $help = null,
        public readonly bool $disabled = false,
        public readonly bool $inverted = false,
        public readonly bool $restrictToMarks = false,
        public readonly bool $labelAlwaysOn = false,
        public readonly bool $showLabelOnHover = true,
        public readonly Size $size = Size::MD,
        public readonly int|null $thumbSize = null,
        public readonly int $precision = 0,
        public readonly string|null $radius = null,
        public readonly string|null $color = null,
    ) {
        parent::__construct('Slider');
    }
}
