<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Common;

trait WithRules
{
    public function required(): self
    {
        $rules = $this->root->rules[$this->key] ?? [];
        $rules = array_values(array_filter($rules, fn (string $r) => $r !== 'nullable'));

        array_unshift($rules, 'required');

        $this->root->rules[$this->key] = $rules;

        return $this;
    }

    public function nullable(): self
    {
        $rules = $this->root->rules[$this->key] ?? [];

        if (!in_array('required', $rules, true)) {
            $rules = array_values(array_filter($rules, fn ($r) => $r !== 'nullable'));
            array_unshift($rules, 'nullable');
        }

        $this->root->rules[$this->key] = $rules;

        return $this;
    }

    /** @param  list<string>  $rules */
    public function rules(array $rules): self
    {
        $existingRules = $this->root->rules[$this->key] ?? [];
        $this->root->rules[$this->key] = array_merge($existingRules, $rules);

        return $this;
    }

    public function rule(string $rule): self
    {
        $this->root->rules[$this->key] = ($this->root->rules[$this->key] ?? []);
        $this->root->rules[$this->key][] = $rule;

        return $this;
    }

    public function maxRule(float|int $n): self
    {
        return $this->rule("max:{$n}");
    }

    public function minRule(float|int $n): self
    {
        return $this->rule("min:{$n}");
    }
}
