<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithMultipleRules
{
    /** @param  list<string>  $rules */
    public function rulesFor(string $key, array $rules): self
    {
        $existingRules = $this->root->rules[$key] ?? [];
        $this->root->rules[$key] = array_merge($existingRules, $rules);

        return $this;
    }

    public function required(): self
    {
        $rulesFrom = $this->root->rules[$this->node->from] ?? [];

        $rulesFrom = $this->excludeNullable($rulesFrom);

        $this->root->rules[$this->node->from] = $rulesFrom;

        $rulesTo = $this->root->rules[$this->node->to] ?? [];

        $rulesTo = $this->excludeNullable($rulesTo);

        $this->root->rules[$this->node->to] = $rulesTo;

        return $this;
    }

    public function nullable(): self
    {
        $rulesFrom = $this->root->rules[$this->node->from] ?? [];

        $rulesFrom = $this->excludeRequired($rulesFrom);

        $this->root->rules[$this->node->from] = $rulesFrom;

        $rulesTo = $this->root->rules[$this->node->to] ?? [];

        $rulesTo = $this->excludeRequired($rulesTo);

        $this->root->rules[$this->node->to] = $rulesTo;

        return $this;
    }

    /**
     * @param  list<string>  $rules
     * @return list<string>
     */
    private function excludeNullable(array $rules): array
    {
        $rules = array_values(array_filter($rules, fn (string $r) => $r !== 'nullable'));

        array_unshift($rules, 'required');

        return $rules;
    }

    /**
     * @param  list<string>  $rules
     * @return list<string>
     */
    private function excludeRequired(array $rules): array
    {
        if (!in_array('required', $rules, true)) {
            $rules = array_values(array_filter($rules, fn ($r) => $r !== 'nullable'));
            array_unshift($rules, 'nullable');
        }

        return $rules;
    }
}
