<?php

declare(strict_types=1);

namespace MSML\Blueprint\DSL\Traits\Specialized;

trait WithRelationEndpoint
{
    public function endpoint(string $url, string $method = 'GET'): self
    {
        $endpointConfig = [
            'url'       => $url,
            'method'    => $method,
            'qParam'    => 'q',
            'labelPath' => 'label',
            'valuePath' => 'value',
            'itemsPath' => 'data',
        ];

        $this->updateNodeWith(['endpoint' => $endpointConfig]);

        if (preg_match('#/(api/)?search/([^/?]+)#', $url, $matches)) {
            $tableName = $matches[2];
            $existingRules = $this->root->rules[$this->key] ?? [];
            $existingRules[] = "exists:{$tableName},id";
            $this->root->rules[$this->key] = $existingRules;
        }

        return $this;
    }

    public function dependsOn(string $field, string|null $param = null): self
    {
        $scope = [
            'dependsOn'     => $field,
            'param'         => $param ?? "{$field}_id",
            'clearOnChange' => true,
        ];

        $this->updateNodeWith(['scope' => $scope]);

        return $this;
    }

    public function debounce(int $ms): self
    {
        $this->updateNodeWith(['debounceMs' => $ms]);

        return $this;
    }
}
