<?php

namespace MSML\Blueprint;

use MSML\Blueprint\Contracts\Blueprint;
use Spatie\LaravelPackageTools\Package;
use MSML\Blueprint\Support\BlueprintResolver;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class LaravelBlueprintServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('blueprint')
            ->hasConfigFile('blueprint');
    }

    public function packageRegistered(): void
    {
        // Register BlueprintResolver as singleton
        $this->app->singleton(BlueprintResolver::class, function ($app) {
            /** @var array<string, class-string<Blueprint>> $blueprints */
            $blueprints = config('blueprint.blueprints', []);

            return new BlueprintResolver($blueprints);
        });

        // Set Laravel Data config defaults to prevent transformation issues
        config([
            'data.max_transformation_depth'                    => config('data.max_transformation_depth', 50),
            'data.throw_when_max_transformation_depth_reached' => config('data.throw_when_max_transformation_depth_reached', false),
            'data.validation_strategy'                         => config('data.validation_strategy', 'always'),
            'data.normalizers'                                 => config('data.normalizers', [
                \Spatie\LaravelData\Normalizers\ModelNormalizer::class,
                \Spatie\LaravelData\Normalizers\ArrayableNormalizer::class,
                \Spatie\LaravelData\Normalizers\ObjectNormalizer::class,
                \Spatie\LaravelData\Normalizers\ArrayNormalizer::class,
                \Spatie\LaravelData\Normalizers\JsonNormalizer::class,
            ]),
        ]);
    }
}
