<?php

declare(strict_types=1);

namespace MSML\Calendar\Tests\stubs\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use MSML\Calendar\tests\stubs\User;

class UserFactory extends Factory
{
    protected $model = User::class;

    /**
     * @return array<string, string>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'email_verified_at' => now(),
            'password' => Hash::make('password'),
            'remember_token' => Str::random(10),
        ];
    }

    public function admin(): static
    {
        return $this->state([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
        ]);
    }
}
