<?php

declare(strict_types=1);

namespace MSML\Calendar\Tests\Stubs;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use MSML\Calendar\Models\CalendarEvent;
use MSML\Calendar\Tests\stubs\factories\UserFactory;

/**
 * @property int $id
 * @property string $name
 * @property string $email
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property \Carbon\Carbon|null $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\MSML\Calendar\Models\CalendarEvent[] $calendarEvents
 */
class User extends Authenticatable
{
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $guarded = [];

    /**
     * @return HasMany<Model, $this>
     */
    public function calendarEvents(): HasMany
    {
        return $this->hasMany(CalendarEvent::class);
    }

    protected static function newFactory(): UserFactory
    {
        return UserFactory::new();
    }
}
