# Laravel Calendar

A lightweight Laravel package to manage a calendar.

## Features

- Models to easily implement a calendar in Laravel
- Support for timed events, all-day events, and events spanning multiple days

## Installation

You can install the package via composer:

```bash
composer require msml/laravel-calendar
```

You can publish and run the migrations with:

```bash
php artisan vendor:publish --tag="calendar-migrations"
php artisan migrate
```

### Customizing Config

You can publish the config file with:

```bash
php artisan vendor:publish --tag="calendar-config"
```

This is the contents of the published config file:

```php
return [
    /*
    |--------------------------------------------------------------------------
    | Event Model
    |--------------------------------------------------------------------------
    |
    | The Eloquent model class to use for calendar events. You can extend
    | the base CalendarEvent model to add custom traits, methods, or
    | relationships. Ensure your custom model extends the base model.
    |
    */
    'event_model' => MSML\Calendar\Models\CalendarEvent::class,

    /*
    |--------------------------------------------------------------------------
    | Event Category Model
    |--------------------------------------------------------------------------
    |
    | The Eloquent model class to use for calendar event categories. You can
    | extend the base CalendarEventCategory model to add custom traits,
    | methods, or relationships. Ensure your custom model extends the base model.
    |
    */
    'event_category_model' => MSML\Calendar\Models\CalendarEventCategory::class,
];


```

## Usage example

```php
use MSML\Calendar\Models\CalendarEventCategory;

// Create a category first
// Or use the calendar:create-calendar-event-category command
$category = CalendarEventCategory::create([
    'name' => 'Meeting',
    'color' => '007bff'
]);

$event = CalendarEvent::Create([
    'category_id' => $category->id,
    'title' => 'Team Meeting',
    'description' => 'Weekly team sync',
    'start' => '2024-01-15 10:00:00',
    'end' => '2024-01-15 11:00:00',
    'allDay' => false,
]);
```

## Testing

```bash
composer test
```

## Credits

- [MSML](https://github.com/msmlbv)
- All contributors

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
